﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public class Login_API : Gemini.Core.WebApplication.Base.APIComponent
    {
        public Login_API(Gemini.Core.WebApplication.Base.APIComponentParam APIComponentParam) : base(APIComponentParam) { }

        public override string Name
        {
            get { return "Login_API"; }
        }

        private BL.ZSBELearning _blELearning = null;
        public BL.ZSBELearning BLELearning
        {
            get
            {
                if (_blELearning == null)
                {
                    _blELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blELearning;
            }
        }
        public override long ClientID
        {
            get { return BLELearning.ClientID; }
        }

        public override bool IsXSLRender { get { return false; } }

        public override Gemini.Core.WebApplication.Interface.IRenderResult Render(System.Xml.Xsl.XslCompiledTransform XSLWebPageComponent)
        {
            if (MethodName == "checklogin")
            {
                //id=XXX&login=XXX&sessionuid=XXX
                string _id = APIRequestParams["id"];
                string _login = APIRequestParams["login"];
                string _sessionuid = APIRequestParams["sessionuid"];

                if (!string.IsNullOrEmpty(_id) && !string.IsNullOrEmpty(_login) && !string.IsNullOrEmpty(_sessionuid))
                {
                    if (BLELearning.IsUserSessionActive(_id, _login, _sessionuid))
                    {
                        return new Gemini.Core.WebApplication.Base.RenderResultBase("&success=1");
                    }
                }
                return new Gemini.Core.WebApplication.Base.RenderResultBase("&success=0");
            }
            if (MethodName == "checksession")
            {
                //id=XXX&sessionuid=7e97a09f-8e79-46d6-bf85-0457c839ba08
                string _id = APIRequestParams["id"];
                string _sessionuid = APIRequestParams["sessionuid"];

                if (!string.IsNullOrEmpty(_id) && !string.IsNullOrEmpty(_sessionuid))
                {
                    if (BLELearning.IsUserSessionActive(_id, _sessionuid))
                    {
                        return new Gemini.Core.WebApplication.Base.RenderResultBase("&success=1");
                    }
                }
                return new Gemini.Core.WebApplication.Base.RenderResultBase("&success=0");
            }
            if (MethodName == "savemoney")
            {
                //id=XXX&money=YYY&check=MD5
                /*
                 * XXX = (id + 19) * 6
                 * YYY = (money + 14) * 3
                 * MD5 = MD5(id.ToString() + "_" + money.ToString()) - liczymy MD5 z takiego ciagu: id_money przed modyfikacja matematyczna
                 * Money jest liczba typu int
                 * 
                 * Dla takich danych:
                 * id=1
                 * money=5
                 * check:MD5("1_5") => 011725bb021b57e9a3e8d9239758bf43
                 * 
                 * mamy taki URL:
                 * /APIPage.aspx?apiname=savemoney&id=120&money=57&check=011725bb021b57e9a3e8d9239758bf43
                 * 
                 */
                string _id = APIRequestParams["id"];
                string _money = APIRequestParams["money"];
                string _check = APIRequestParams["check"];

                if (!string.IsNullOrEmpty(_id) && !string.IsNullOrEmpty(_money) && !string.IsNullOrEmpty(_check))
                {
                    long _idLong = (long.Parse(_id) / 6) - 19;
                    int _moneyInt = (int.Parse(_money) / 3) - 14;

                    string _checkString = string.Format("{0}_{1}", _idLong, _moneyInt.ToString());
                    if (_check == BL.API.Utils.MD5.Generate(_checkString))
                    {
                        if (BLELearning.UpdateStudentMoney(_idLong, _moneyInt))
                        {
                            return new Gemini.Core.WebApplication.Base.RenderResultBase("success=true");
                        }
                    }
                }
            }

            return new Gemini.Core.WebApplication.Base.RenderResultBase("success=false");
        }
    }
}